/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.service;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.posprinter.asynncTask.PosAsynncTask;
import net.posprinter.posprinterface.BackgroundInit;
import net.posprinter.posprinterface.IMyBinder;
import net.posprinter.posprinterface.ProcessData;
import net.posprinter.posprinterface.TaskCallback;
import net.posprinter.utils.PosPrinterDev;
import net.posprinter.utils.RoundQueue;

public class PosprinterService
extends Service {
    private PosPrinterDev printerDev;
    private ArrayList<PosPrinterDev> PrinterDevList = new ArrayList();
    private PosPrinterDev.ReturnMessage mMsg;
    private boolean isConnected = false;
    private RoundQueue<byte[]> que;
    private IBinder myBinder = new MyBinder();

    private RoundQueue<byte[]> getinstaceRoundQueue() {
        if (this.que == null) {
            this.que = new RoundQueue(500);
        }
        return this.que;
    }

    public void onCreate() {
        super.onCreate();
        this.que = this.getinstaceRoundQueue();
        Log.i((String)"TAG", (String)"onCreate");
    }

    public IBinder onBind(Intent intent) {
        Log.i((String)"TAG", (String)"onBind");
        return this.myBinder;
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.printerDev != null) {
            this.printerDev.Close();
        }
    }

    public class MyBinder
    extends Binder
    implements IMyBinder {
        private String USBName;
        private Context Context;
        private PosPrinterDev dev;
        private PosPrinterDev.PortType portTp;
        private List<String> mFound;
        private List<String> mBound;
        private BluetoothAdapter mbBluetoothAdapter;
        private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.bluetooth.device.action.FOUND")) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    MyBinder.this.mFound.add(device.getName() + '\n' + device.getAddress());
                }
            }
        };

        @Override
        public void ConnectNetPort(final String ethernetIP, final int ethernetPort, TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.printerDev = new PosPrinterDev(PosPrinterDev.PortType.Ethernet, ethernetIP, ethernetPort);
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Open();
                    MyBinder.this.portTp = PosPrinterDev.PortType.Ethernet;
                    try {
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                            PosprinterService.this.isConnected = true;
                            Log.e((String)"connectNetPort", (String)"connect ok");
                            PosprinterService.this.PrinterDevList.add(PosprinterService.this.printerDev);
                            return true;
                        }
                        Log.e((String)"connectNetPort", (String)"conect fail");
                        PosprinterService.this.isConnected = false;
                        return false;
                    }
                    catch (Exception var2) {
                        var2.printStackTrace();
                        Log.e((String)"connectNetPort", (String)"connect fail");
                        return false;
                    }
                }
            });
            Log.e((String)"connectNetPort", (String)"connect ok");
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void ConnectBtPort(final String bluetoothID, TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.printerDev = new PosPrinterDev(PosPrinterDev.PortType.Bluetooth, bluetoothID);
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Open();
                    MyBinder.this.portTp = PosPrinterDev.PortType.Bluetooth;
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void ConnectUsbPort(final Context context, final String usbPathName, TaskCallback callback) {
            this.USBName = usbPathName;
            this.Context = context;
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.printerDev = new PosPrinterDev(PosPrinterDev.PortType.USB, context, usbPathName);
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Open();
                    MyBinder.this.portTp = PosPrinterDev.PortType.USB;
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void DisconnectCurrentPort(TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Close();
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.ClosePortSuccess)) {
                        PosprinterService.this.isConnected = false;
                        if (PosprinterService.this.que != null) {
                            PosprinterService.this.que.clear();
                        }
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void Write(final byte[] data, TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    if (data != null) {
                        PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(data);
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                            PosprinterService.this.isConnected = true;
                            return true;
                        }
                        PosprinterService.this.isConnected = false;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void WriteSendData(TaskCallback callback, final ProcessData processData) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    List<byte[]> list = processData.processDataBeforeSend();
                    if (list == null) {
                        return false;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(list.get(i));
                    }
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void writeDataByUSB(TaskCallback callback, final ProcessData processData) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    List<byte[]> list = processData.processDataBeforeSend();
                    if (list != null) {
                        try {
                            for (int i = 0; i < list.size(); ++i) {
                                PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(list.get(i));
                            }
                            if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                                PosprinterService.this.isConnected = true;
                                return true;
                            }
                            PosprinterService.this.isConnected = false;
                        }
                        catch (NullPointerException var3) {
                            var3.printStackTrace();
                            PosprinterService.this.isConnected = false;
                            return false;
                        }
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void Acceptdatafromprinter(TaskCallback callback, int cout) {
            final byte[] buffer = new byte[cout];
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.que = PosprinterService.this.getinstaceRoundQueue();
                    PosprinterService.this.que.clear();
                    Log.i((String)"TAG", (String)PosprinterService.this.printerDev.Read(buffer).GetErrorCode().toString());
                    PosprinterService.this.que.addLast(buffer);
                    Log.i((String)"TAG", (String)("\u5f00\u59cb\u8bfb\u53d6" + Arrays.toString((byte[])PosprinterService.this.que.getLast())));
                    return true;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public RoundQueue<byte[]> ReadBuffer() {
            new RoundQueue(500);
            RoundQueue queue = PosprinterService.this.que;
            return queue;
        }

        @Override
        public void ClearBuffer() {
            PosprinterService.this.que.clear();
        }

        @Override
        public void CheckLinkedState(TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    return PosprinterService.this.printerDev != null ? PosprinterService.this.printerDev.GetPortInfo().PortIsOpen() : false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void DisconnetNetPort(TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Close();
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.ClosePortSuccess)) {
                        PosprinterService.this.isConnected = false;
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public List<String> OnDiscovery(PosPrinterDev.PortType portType, Context context) {
            this.mBound = new ArrayList<String>();
            this.mFound = new ArrayList<String>();
            if (portType == PosPrinterDev.PortType.Bluetooth) {
                this.mbBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (this.mbBluetoothAdapter == null) {
                    Toast.makeText((Context)context, (CharSequence)"device didn't suport bluetooth!", (int)0).show();
                    return null;
                }
                if (this.mbBluetoothAdapter.isEnabled()) {
                    if (this.mbBluetoothAdapter.enable()) {
                        if (!this.mbBluetoothAdapter.isDiscovering()) {
                            this.mbBluetoothAdapter.startDiscovery();
                        }
                        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
                        PosprinterService.this.registerReceiver(this.mReceiver, filter);
                        Set pairedDevice = this.mbBluetoothAdapter.getBondedDevices();
                        if (pairedDevice.size() > 0) {
                            for (BluetoothDevice device : pairedDevice) {
                                this.mBound.add(device.getName() + "\n" + device.getAddress());
                            }
                        } else {
                            Toast.makeText((Context)context, (CharSequence)"no paired device !", (int)0).show();
                        }
                    } else {
                        Toast.makeText((Context)context, (CharSequence)"enabel bluetooth fail1,", (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)context, (CharSequence)"enabel bluetooth fail2,", (int)0).show();
                }
                if (this.mBound != null && this.mFound != null) {
                    this.mBound.addAll(this.mFound);
                }
            } else if (portType == PosPrinterDev.PortType.USB) {
                this.mBound = PosPrinterDev.GetUsbPathNames(context);
            }
            return this.mBound;
        }

        @Override
        public List<String> getBtAvailableDevice() {
            this.mbBluetoothAdapter.cancelDiscovery();
            return this.mFound;
        }
    }
}

