/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import java.util.ArrayList;
import java.util.List;

public class BitmapProcess {
    public static Bitmap compressBmpByPrinterWidth(Bitmap bitmap, PrinterWidth printerWidth) {
        int w;
        Bitmap resizedBitmap = null;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        switch (printerWidth.ordinal()) {
            case 1: {
                w = 576;
                break;
            }
            case 2: {
                w = 508;
                break;
            }
            case 3: {
                w = 384;
                break;
            }
            default: {
                w = 576;
            }
        }
        if (width <= w) {
            return bitmap;
        }
        int newHeight = height * w / width;
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static Bitmap compressBmpByYourWidth(Bitmap bitmap, int w) {
        Bitmap resizedBitmap = null;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width <= w) {
            return bitmap;
        }
        int newHeight = height * w / width;
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static Bitmap rotateBmp(Bitmap bitmap, RotateType rotateType) {
        Matrix matrix = new Matrix();
        float degrees = 0.0f;
        switch (rotateType.ordinal()) {
            case 1: {
                degrees = 90.0f;
                break;
            }
            case 2: {
                degrees = 180.0f;
                break;
            }
            case 3: {
                degrees = 270.0f;
            }
        }
        matrix.postRotate(degrees);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap2;
    }

    public static List<Bitmap> cutBitmap(int h, Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        boolean full = height % h == 0;
        int n = height % h == 0 ? height / h : height / h + 1;
        ArrayList<Bitmap> bitmaps = new ArrayList<Bitmap>();
        for (int i = 0; i < n; ++i) {
            Bitmap b = full ? Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(i * h), (int)width, (int)h) : (i == n - 1 ? Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(i * h), (int)width, (int)(height - i * h)) : Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(i * h), (int)width, (int)h));
            bitmaps.add(b);
        }
        return bitmaps;
    }

    public static Bitmap resizeImage(Bitmap bitmap, int w, boolean isOriginal) {
        Bitmap resizedBitmap = null;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width <= w) {
            return bitmap;
        }
        if (!isOriginal) {
            int newHeight = height * w / width;
            float scaleWidth = (float)w / (float)width;
            float scaleHeight = (float)newHeight / (float)height;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        } else {
            resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)height);
        }
        return resizedBitmap;
    }

    static enum RotateType {
        Rotate90,
        Rotate180,
        Rotate270;

    }

    static enum PrinterWidth {
        Pos80,
        Pos76,
        Pos58;

    }
}

