/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.utils;

import java.io.Serializable;
import java.util.NoSuchElementException;

public class RoundQueue<T>
implements Serializable {
    private static final long serialVersionUID = -873109114121357176L;
    private T[] queue;
    private int head = 0;
    private int tail = 0;
    private int realSize = 0;

    public RoundQueue(int size) {
        this.queue = new Object[size <= 0 ? 500 : size];
    }

    public void addLast(T element) {
        if (this.isFull()) {
            this.removeFirst();
        }
        this.tail = (this.head + this.realSize) % this.queue.length;
        this.queue[this.tail] = element;
        ++this.realSize;
    }

    public T removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        T tempLog = this.queue[this.head];
        this.queue[this.head] = null;
        this.head = (this.head + 1) % this.queue.length;
        --this.realSize;
        return tempLog;
    }

    public int realSize() {
        return this.realSize;
    }

    public boolean isEmpty() {
        return this.realSize() == 0;
    }

    public boolean isFull() {
        return this.realSize() == this.queue.length;
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.removeFirst();
        }
    }

    public T get(int index) {
        if (index >= 0 && index < this.realSize) {
            return this.queue[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.realSize);
    }

    public int indexOf(T key) {
        if (key == null) {
            return -1;
        }
        for (int index = 0; index <= this.realSize() - 1; ++index) {
            if (!key.equals(this.queue[index])) continue;
            return index;
        }
        return -1;
    }

    public int gethead() {
        return this.head;
    }

    public int gettail() {
        return this.tail;
    }

    public T getLast() {
        return this.queue[this.tail];
    }

    public T getFirst() {
        return this.queue[this.head];
    }
}

